require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../common/accessVarUtility'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/request_settings'
require_relative '../../pages/varUtility/manage_settings/direct_scheduling'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'

require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'

describe '[Story VARUT-13 : Utility - Direct Appointments
                                   - View/Edit Service Patient History Limit],
          [Story VARUT-60 : Utility - Navigate without Saving Warning],
          [Story VARUT-219: Utility - Direct Scheduling Screen - Update labels]'  do
  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @db = connectToVarMongoDB("var-utility")
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @base = Base.new(@driver)
    @direct_scheduling = Direct_Scheduling.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)
    @loginUtil = AccessVarUtility.new(@driver)

    @landing_page = LandingPage.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
    @home = Home.new(@driver)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-187|TC#VARUT-186: Test - View/Edit Service Patient History Limit' do
    #Reset Data in Mongo DB
    it "Remove Mongo" do
      removeCollection("directBookingEligibilityCriteria", @db)
    end

    it "Login" do
      @loginUtil.access_var_utility(UserAccess7)
      @landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
    end


    context 'AC#VARUT-266|TC#VARUT-267: Test - Validate column name change and drop down value changes' do
      it "Direct Scheduling Page" do
        @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
        @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
        expect(@vts_po.landing.primary_header).to eq("Welcome")

        @manage_setting.clickOption('Direct Scheduling')
        expect(@landing.primary_header).to eq("Direct Scheduling")

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@table.tableList_elements.length).to eq(4)

        expect(@table.getNthTableHeader(0)).to include("Type of Care")
        expect(@table.getNthTableHeader(1)).to eq("Supported at this Facility?")
        expect(@table.getNthTableHeader(2)).to eq("* Last seen within (Months)")

        #Column1 data
        expect(@table.getTextForRowCol(1,1)).to include("Primary Care")
        expect(@table.getTextForRowCol(2,1)).to include("Audiology")
        expect(@table.getTextForRowCol(3,1)).to include("Optometry")
        expect(@table.getTextForRowCol(4,1)).to include("Outpatient Mental Health")

        #Column2 data
        expect(@direct_scheduling.primaryCare_options[0]).to eq("No")
        expect(@direct_scheduling.primaryCare_options[1]).to eq("Yes - With PACT Assignment")
        expect(@direct_scheduling.audiology_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
        expect(@direct_scheduling.optometry_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
        expect(@direct_scheduling.outpatientMentalHealth_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])

      end

      it "Validate Type of Care = Primary Care" do
        #Type of care = Primary Care
        #Last Seen Within column - no options
        @direct_scheduling.primaryCare = "No"
        expect(@direct_scheduling.primarycareOptionLastSeen).to eq("")
        @direct_scheduling.primaryCare = "Yes - With PACT Assignment"
        expect(@direct_scheduling.primarycareOptionLastSeen).to eq("")
      end

      it "Validate Type of Care = Audiology" do
        #Type of Care = Audiology
        @direct_scheduling.audiology = "No"
        expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(false)

        @direct_scheduling.audiology = "Yes - Any Veteran"
        expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(false)

      end

      it "Validate Type of Care = Optometry" do
        #Type of Care = Optometry
        @direct_scheduling.optometry = "No"
        expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(false)

        @direct_scheduling.optometry = "Yes - Any Veteran"
        expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(false)

      end

      it "Validate Type of Care = Outpatient Mental Health" do
        #Type of Care = Outpatient Mental Health
        @direct_scheduling.outpatientMentalHealth = "No"
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

        @direct_scheduling.outpatientMentalHealth = "Yes - Any Veteran"
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

      end

      it "Validate Confirmation Modal on Save" do
        #Audiology
        @direct_scheduling.audiology = "Yes - Based Upon Time Frame"
        expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(true)
        expect(@direct_scheduling.audiologyLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @direct_scheduling.audiologyLastSeen = "24 months (730 days)"

        #Optometry
        @direct_scheduling.optometry = "Yes - Based Upon Time Frame"
        expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(true)
        expect(@direct_scheduling.optometryLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @direct_scheduling.optometryLastSeen = "12 months (365 days)"

        #Outpatient Mental Health
        @direct_scheduling.outpatientMentalHealth = "Yes - Based Upon Time Frame"
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(true)
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @direct_scheduling.outpatientMentalHealthLastSeen = "24 months (730 days)"

        @direct_scheduling.bottomSave


        #Validate Confirmation Modal
        @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

        expect(@modal.modalTitle).to include("Confirmation")
        expect(@modal.content).to eq("The Direct Scheduling settings have been saved.")

        @modal.ok

        Watir::Wait.until {@table.tableList_elements.length > 1}

        @direct_scheduling.audiology_element.when_visible(TIME_OUT_LIMIT)

        #Validate that the selections are saved.
        expect(@direct_scheduling.primaryCare).to eq("Yes - With PACT Assignment")
        expect(@direct_scheduling.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@direct_scheduling.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.optometryLastSeen).to eq("12 months (365 days)")
        expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      end

      it "Retrieve mongo" do
        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 0, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(AUDIOLOGY).to eq(value['typeOfCare'].to_s)
        expect("730").to eq(value['patientHistoryDuration'].to_s)
        expect(true).to eq(value['canCancel'])

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 1, @db)
        expect("No").to eq(value['patientHistoryRequired'].to_s)
        expect(PRIMARY_CARE).to eq(value['typeOfCare'].to_s)
        expect(true).to eq(value['canCancel'])

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 2, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(OPTOMETRY).to eq(value['typeOfCare'].to_s)
        expect("365").to eq(value['patientHistoryDuration'].to_s)
        expect(true).to eq(value['canCancel'])

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 3, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(MENTAL_HEALTH).to eq(value['typeOfCare'].to_s)
        expect("730").to eq(value['patientHistoryDuration'].to_s)
        expect(true).to eq(value['canCancel'])

      end

      it "Error validation" do
        #Last Seen in Months is a required field
        #Click Save without selecting a value for last seen for Audiology Optometry and Outpatient Mental health

        @direct_scheduling.audiologyLastSeen = "Select"
        @direct_scheduling.optometryLastSeen = "Select"
        @direct_scheduling.outpatientMentalHealthLastSeen = "Select"
        @direct_scheduling.topSave

        @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)

        expect(@direct_scheduling.error_message_element.text).to eq("Last Seen Within (Months) " + AUDIOLOGY + " field is required\nLast Seen Within (Months) " + OPTOMETRY + " field is required\nLast Seen Within (Months) " + MENTAL_HEALTH + " field is required")

        #Click Cancel reverts back to the last saved state and error messages are not displayed
        @direct_scheduling.topCancel_element.wait_until_present(TIME_OUT_LIMIT)
        @direct_scheduling.topCancel

        expect(@error.errorSummaryHeader_element.visible?).to eq(false)

      end

      it "Logout and Log back in as different user for same location to verify the last saved data is displayed" do
        @common.logoutAndLogbackWithADifferentUser("ACCESS50", "VERIFY50!", "BOSTON HCS VAMC")

        @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
        expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, FIFTY")

        @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
        @home.varUtilOpen
        @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
        @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
        @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
        @landing_page.view_settings

        sleep 5

        @manage_setting.clickOption('Direct Scheduling')
        expect(@landing.primary_header).to eq("Direct Scheduling")

        Watir::Wait.until {@table.tableList_elements.length > 1}

        #Validate the selections
        expect(@direct_scheduling.primaryCare).to eq("Yes - With PACT Assignment")
        expect(@direct_scheduling.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@direct_scheduling.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.optometryLastSeen).to eq("12 months (365 days)")
        expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      end

      context 'AC#VARUT-211|TC#VARUT-212: Utility - Navigate without Save Confirmation Modal Validate' do
        it "Navigate without save and validate changes are not saved" do
          #Select different values for each field other than what is being saved.
          @direct_scheduling.primaryCare = "No"
          @direct_scheduling.audiology = "Yes - Any Veteran"
          @direct_scheduling.optometry = "Yes - Any Veteran"
          @direct_scheduling.outpatientMentalHealth = "Yes - Any Veteran"

          #Click the home icon and validate the confirmation modal

          @base.home_btn

          @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

          expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")
          expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          @modal.return

          Watir::Wait.until {@table.tableList_elements.length > 1}

          #Validate the last selected values
          expect(@direct_scheduling.primaryCare).to eq("No")
          expect(@direct_scheduling.audiology).to eq("Yes - Any Veteran")
          expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(false)
          expect(@direct_scheduling.optometry).to eq("Yes - Any Veteran")
          expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(false)
          expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Any Veteran")
          expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

          #Select Continue in the confirmation modal
          #@base.home_btn
          button_element = @driver.button( :id=>'home-btn')
          @driver.execute_script("$(arguments[0]).click();",button_element)

          @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
          expect(@modal.modalTitle).to include("Confirmation")

          @modal.ok

          sleep 5

          #Go back to Direct Scheduling and verify the last saved selections are displayed
          @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
          @home.varUtilOpen

          @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
          @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
          @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
          @landing_page.view_settings


          #expect(@manage_setting.manage_settings_options_elements.when_present(TIME_OUT_LIMIT))
          sleep (3)
          @manage_setting.clickOption('Direct Scheduling')

          Watir::Wait.until {@table.tableList_elements.length > 1}

          expect(@direct_scheduling.primaryCare).to eq("Yes - With PACT Assignment")
          expect(@direct_scheduling.audiology).to eq("Yes - Based Upon Time Frame")
          expect(@direct_scheduling.audiologyLastSeen).to eq("24 months (730 days)")
          expect(@direct_scheduling.optometry).to eq("Yes - Based Upon Time Frame")
          expect(@direct_scheduling.optometryLastSeen).to eq("12 months (365 days)")
          expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
          expect(@direct_scheduling.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

        end
      end
    end
  end
end





